# Vespucci 14.0 Highlights

2019-10-20

### Changes in download menu

We've now removed the "Download at other location" as the functionality can just as well be obtained by using the find function and then downloading. The _Download current view_ function now merges data, to replace the data in memory you will need to selec _Clear and download current view_. 

These changes makes the behaviour more similar to JOSM and reduces some unnecessary clutter.

### Automatically apply preset when property editor is invoked

This is a significant behaviour change relative to earlier versions. When the property editor is invoked the best preset will be applied (without optional tags), in other words fields will be shown with empty values for such tags.

Automatically applying the preset has some dangers as, depending on the preset, existing values could be overwritten, if that happens a warning will be shown.

The feature can be turned off in the [Advanced preferences](Advanced%20preferences.md).

### Pan and zoom auto downloading

This release adds support for downloading data and tasks in a more conventional way by retrieving the data covered by the current screen. To keep the amount of data in memory in check a manual facility to prune the data in storage to the screen contents (plus a tolerance) is available via the layer dialog entries for the data and task layers. Additionally the data layer will try to "auto-prune" the stored data once it has reached a configurable number of Nodes in memory  [Advanced preferences](Advanced%20preferences.md). 

The auto-download speed limit preferences will be observed both for data and tasks. 

IMPORTANT: this facility should only be used with caution as it has the potential to severely tax both the OpenStreetMap APIs and your device. The former can be 
reduced by using an offline data source.

CAVEAT: if you are using an offline data source you should complete all your edits in the area before uploading, as uploading makes new or modified data eligible for pruning and re-visiting the same area before updating the read-only source would give you stale data. Instead of uploading regularly you can save your changes either as a JOSM style OSM file or as in OSC format. 

### Internal photo viewer

The internal viewer is used be default in place of trying to start an external on device gallery or viewer app, it allows deleting and "sharing" of photos directly from Vespucci. When started via a click on a photo icon it will load references to all photos currently in view. 

In the current version the photo is shown in a dialog, however we intend to integrate it in a split window view in the future.

The feature can be turned off in the [Advanced preferences](Advanced%20preferences.md).

### Incremental preset search

THe preset search will now search while you are typing and display the results directly in the preset display. As we integrated the name suggestion index in to the same search in 13.1, the separately available name search dialog in non-simple mode has been removed.

### On-the-fly custom presets

_This is an experimental feature._

A custom preset can be built from existing tags in the "Details" view in the property editor. Select the tags you want to include, then select "Create custom preset" from the menu and then enter a name when you are prompted. The new preset can then be found in the "Auto-preset" group.

The function tries to do the "right thing" by not including the values for tags that have "name" semantics, and setting the current value for combo and multi-select fields as the default value.

### "Tip" display function

A function has been added to display tips on certain functions. Every tip will be displayed only once, optional ones can be suppressed by setting an option in the display itself, non-optional ones will always be displayed once. 

### Support for multi-valued but editable tags

Some tags, for example phone numbers, lane values, allow multiple values that can't be or are difficult to edit with the previously available forms. 14.0 adds a view for phone numbers and for editable multi-select fields that will display multiple vertically arranged text fields that can be individually edited, and in the case of multi-select fields will have individual drop downs.

Buttons to apply the preset without optional tags have been added too.

### Automatic phone number formatting

_This is an experimental feature._

When entering a new phone number the number is automatically formated correctly for the country the object is in. Further the same formating is applied when invoking the property editor, a warning will be displayed if this actually happens.

### Unjoin way

Previously unjoining a way required selecting a node at where you wanted to unjoin ways and resulted in all ways except one receiving new nodes. This makes sense for example when you are trying to rewire a junction, however not so much if you want to "unglue" landuse joined to a road and similar constructs. While this wasn't a classical use case for Vespucci, but as the app gets used more and more for nearly everything, we've now added support for more classical unjoin options.

There are two option when you have selected a way that has shared nodes with other ways:

 * __Unjoin__ this will simply replace all nodes in the way with copies of the original nodes.
 * __Unjoin dissimilar__ this will replace nodes as above, but additionally replace nodes in similar ways if necessary to maintain connections.
 
An example of the later function: assume you have landuse glued to a way from both sides and additionally other roads connecting to to it. If you use the basic __Unjoin__ option the way will be disconnected form the lanuse but also from all the roads connecting to it, if you use __Unjoin dissimilar__ the connections to the roads will be maintained.

## Miscellaneous

* Selection of OAM imagery has been moved to the layer dialog and imagery configuration removed the preferences with the exception of adding custom imagery.
* Allow Vespucci to consume intents to show photos from other apps. Note: due to the ongoing changes in the way Android controls access to files this may or not may work reasonably.
* If you have left a changeset open after an upload, you can close it before the next upload with an option in the upload dialog.
* Undo and redo checkpoint lists have been moved to separate tabs in the display. 
* Go back to last edit function added, this will pan and zoom to the bounding box of the top most undo checkpoint.
* "Squaring" / "Straightening" threshold is now adjustable in the  [Advanced preferences](Advanced%20preferences.md). The process itself is now done asynchronously and doesn't lock up the device anymore. 
* The preferences can now be changed from within the property editor too.
* Multi-select now support copying and cutting multiple objects to the clipboard, and pasting of multiple objects.
* Merging a node in to another node or way will now show a context menu if there are multiple candidate target elements and offer the option of merging with all candidates. 
* Support country specific presets.
* The presets now include some entries for disused:* objects.
* Lots of stability improvements.

# Upgrading from previous versions

* As the saved state file format changed for version 14.0, please complete any edits before upgrading if your current version is older.

# Known problems

* The documentation is out of date.
* For known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)

